/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.controller.GramStructShell;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.nooj4nlp.controller.GrammarEditorShell.GrammarEditorShellController;
import net.nooj4nlp.engine.Graph;
import net.nooj4nlp.gui.main.Launcher;
import net.nooj4nlp.gui.shells.GramStructShell;
import net.nooj4nlp.gui.shells.GrammarEditorShell;

public class GramStructShellController {
    public JTree tvGraphs;
    public GrammarEditorShell formGrammar;
    public GramStructShell structShell;
    public static int occ;
    private boolean[] visited;
    private boolean hack_clearing;

    public GramStructShellController(GramStructShell s, GrammarEditorShell shell) {
        this.structShell = s;
        this.tvGraphs = s.tvGraphs;
        this.formGrammar = shell;
        occ = 0;
    }

    public void expandAll(boolean expand) {
        TreeNode root = (TreeNode)this.tvGraphs.getModel().getRoot();
        this.expandAll(this.tvGraphs, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (parent.getPathCount() == 1) {
            return;
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public int findGraph(String gname) {
        int index = -1;
        for (int ig = 0; ig < this.formGrammar.getController().grammar.graphs.size(); ++ig) {
            Graph grf2 = this.formGrammar.getController().grammar.graphs.get(ig);
            if (grf2 == null || !grf2.name.equals(gname)) continue;
            index = ig;
            break;
        }
        return index;
    }

    String getNameFromTreeNodeLabel(String text) {
        String label = text;
        int le = label.length();
        if (le > 4 && label.substring(le - 4, le - 2).equals(" (") && label.substring(le - 1, le).equals(")")) {
            label = label.substring(0, le - 4);
        }
        return label;
    }

    boolean isRecursive(String gname, TreeNode node) {
        for (node = node.getParent(); node != null; node = node.getParent()) {
            String label = this.getNameFromTreeNodeLabel(node.toString());
            if (!label.equals(gname)) continue;
            return true;
        }
        return false;
    }

    private boolean isChild(String gname, TreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!node.getChildAt(i).toString().equals(gname)) continue;
            return true;
        }
        return false;
    }

    public void visit(JTree tv) {
        String gname;
        Graph grf;
        int i;
        this.hack_clearing = true;
        ((DefaultMutableTreeNode)tv.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)tv.getModel()).reload();
        this.hack_clearing = false;
        this.visited = new boolean[this.formGrammar.getController().grammar.graphs.size()];
        for (int i2 = 0; i2 < this.formGrammar.getController().grammar.graphs.size(); ++i2) {
            this.visited[i2] = false;
        }
        DefaultMutableTreeNode top = (DefaultMutableTreeNode)tv.getModel().getRoot();
        int index = -1;
        for (i = 0; i < this.formGrammar.getController().grammar.graphs.size(); ++i) {
            grf = this.formGrammar.getController().grammar.graphs.get(i);
            if (grf == null || !(gname = grf.name).equals("Main")) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.visited[index] = true;
            Graph grf2 = this.formGrammar.getController().grammar.graphs.get(index);
            if (grf2 != null) {
                String gname2 = grf2.name;
                DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname2);
                top.add(tn);
                this.visitEmbeddedGraphs(grf2, tn);
            }
        }
        for (i = 0; i < this.formGrammar.getController().grammar.graphs.size(); ++i) {
            if (this.visited[i]) continue;
            this.visited[i] = true;
            grf = this.formGrammar.getController().grammar.graphs.get(i);
            if (grf == null) continue;
            gname = grf.name;
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname);
            top.add(tn);
            this.visitEmbeddedGraphs(grf, tn);
        }
        ((DefaultTreeModel)tv.getModel()).reload();
        tv.setEnabled(true);
        tv.update(this.tvGraphs.getGraphics());
    }

    public void recursiveDelete(TreeNode currentNode, int current) {
        int ig;
        this.hack_clearing = true;
        JTree tv = this.tvGraphs;
        ((DefaultMutableTreeNode)tv.getModel().getRoot()).removeAllChildren();
        ((DefaultTreeModel)tv.getModel()).reload();
        this.hack_clearing = false;
        this.visited = new boolean[this.formGrammar.getController().grammar.graphs.size()];
        for (int i = 0; i < this.formGrammar.getController().grammar.graphs.size(); ++i) {
            this.visited[i] = false;
        }
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("");
        ((DefaultTreeModel)tv.getModel()).setRoot(top);
        this.visited[current] = true;
        Graph grf = this.formGrammar.getController().grammar.graphs.get(current);
        if (grf != null) {
            String gname = grf.name;
            DefaultMutableTreeNode tn = new DefaultMutableTreeNode(gname);
            top.add(tn);
            this.visitEmbeddedGraphs(grf, tn);
        }
        for (ig = 0; ig < this.formGrammar.getController().grammar.graphs.size(); ++ig) {
            if (!this.visited[ig]) continue;
            this.formGrammar.getController().grammar.graphs.set(ig, null);
        }
        ig = 0;
        while (ig < this.formGrammar.getController().grammar.graphs.size()) {
            Graph g = this.formGrammar.getController().grammar.graphs.get(ig);
            if (g == null) {
                this.formGrammar.getController().grammar.graphs.remove(ig);
                continue;
            }
            ++ig;
        }
        this.tvGraphs.update(this.tvGraphs.getGraphics());
    }

    public void renameNodes(DefaultMutableTreeNode tn, String oldname, String newname) {
        String label = tn.toString();
        if (label.length() > 4 && label.substring(label.length() - 4).equals(" (R)")) {
            if ((label = label.substring(0, label.length() - 4)).equals(oldname)) {
                tn = new DefaultMutableTreeNode(newname + " (R)");
            }
            return;
        }
        if (tn.toString().equals(oldname)) {
            tn = new DefaultMutableTreeNode(newname);
        }
        if (tn.getChildCount() == 0) {
            return;
        }
        for (int i = 0; i < tn.getChildCount(); ++i) {
            DefaultMutableTreeNode t = (DefaultMutableTreeNode)tn.getChildAt(i);
            if (t.toString().equals(oldname)) {
                t.setUserObject(newname);
            }
            if (this.isRecursive(t.toString(), t)) continue;
            this.renameNodes(t, oldname, newname);
        }
    }

    int verif(Object r, String oldname, String newname) {
        TreeNode root = (TreeNode)r;
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (root.getChildAt(i).isLeaf()) {
                String aux = root.getChildAt(i).toString();
                if (!aux.equals(newname)) continue;
                ++occ;
                continue;
            }
            this.verif(root.getChildAt(i), oldname, newname);
        }
        return occ;
    }

    public void rename(String oldname, String newname) {
        int verif = this.verif(this.tvGraphs.getModel().getRoot(), oldname, newname);
        if (verif <= 1) {
            for (int i = 0; i < this.formGrammar.getController().grammar.graphs.size(); ++i) {
                Graph grf = this.formGrammar.getController().grammar.graphs.get(i);
                if (grf == null) continue;
                if (grf.name.equals(oldname)) {
                    grf.name = newname;
                }
                for (int inode = 0; inode < grf.label.size(); ++inode) {
                    ArrayList<String> recterms;
                    if (inode == 1 || grf.commentNode(inode) || grf.areaNode(inode) || (recterms = Graph.embGraphsLabel(grf.label.get(inode))) == null) continue;
                    grf.renameEmbeddedGraphInLabel(inode, oldname, newname);
                }
            }
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.tvGraphs.getModel().getRoot();
            this.renameNodes(tn, oldname, newname);
            this.tvGraphs.update(this.tvGraphs.getGraphics());
            occ = 0;
        } else {
            JOptionPane.showMessageDialog(Launcher.desktopPane, "Name " + newname + " is already used for another graph", "NooJ", 1);
            DefaultMutableTreeNode changedNode = (DefaultMutableTreeNode)this.tvGraphs.getLastSelectedPathComponent();
            changedNode.setUserObject(oldname);
            occ = 0;
        }
    }

    private void visitEmbeddedGraphs(Graph grf, DefaultMutableTreeNode tn) {
        int nbofnodes = grf.label.size();
        for (int inode = 0; inode < nbofnodes; ++inode) {
            ArrayList<String> recterms;
            if (inode == 1 || grf.commentNode(inode) || grf.areaNode(inode) || (recterms = Graph.embGraphsLabel(grf.label.get(inode))) == null) continue;
            for (int iterm = 0; iterm < recterms.size(); ++iterm) {
                DefaultMutableTreeNode ntn;
                int i;
                int index;
                String gname = recterms.get(iterm);
                if (this.isChild(gname, tn)) continue;
                if (this.isRecursive(gname, tn)) {
                    index = -1;
                    for (i = 0; i < tn.getChildCount(); ++i) {
                        if (!tn.getChildAt(i).toString().equals(gname + " (R)")) continue;
                        index = i;
                        break;
                    }
                    if (index != -1) continue;
                    ntn = new DefaultMutableTreeNode(gname + " (R)");
                    tn.add(ntn);
                    continue;
                }
                index = this.findGraph(gname);
                if (index != -1) {
                    this.visited[index] = true;
                    ntn = new DefaultMutableTreeNode(gname);
                    tn.add(ntn);
                    Graph grf2 = this.formGrammar.getController().grammar.graphs.get(index);
                    this.visitEmbeddedGraphs(grf2, ntn);
                    this.tvGraphs.update(this.tvGraphs.getGraphics());
                    continue;
                }
                index = -1;
                for (i = 0; i < tn.getChildCount(); ++i) {
                    if (!tn.getChildAt(i).toString().equals(gname + " (X)")) continue;
                    index = i;
                    break;
                }
                if (index == -1) {
                    ntn = new DefaultMutableTreeNode(gname + " (X)");
                    tn.add(ntn);
                }
                this.tvGraphs.update(this.tvGraphs.getGraphics());
            }
        }
    }

    public boolean isHack_clearing() {
        return this.hack_clearing;
    }

    public GrammarEditorShellController getFormGrammar() {
        return this.formGrammar.getController();
    }
}

